import React, { FC, ComponentType } from 'react';
import { RenderRuntime } from '../typings/runtime';
export interface Props {
    runtime: RenderRuntime;
}
export interface WithDeviceProps {
    deviceInfo: DeviceInfo;
}
export declare enum Device {
    phone = "phone",
    tablet = "tablet",
    desktop = "desktop",
    unknown = "unknown"
}
export interface DeviceInfo {
    type: Device;
    isMobile: boolean;
}
export declare const withDevice: <P extends Props>(Component: React.ComponentType<P & WithDeviceProps>) => React.FC<P>;
