import { DeviceInfo } from './withDevice';
import { ApolloClientType, FetchNavigationDataInput, ParsedPageQueryResponse, FetchDefaultPages, ParsedDefaultPagesQueryResponse, PrefetchRouteData, ContentResponse, ParsedServerPageResponse } from '../typings/global';
import { RenderRuntime } from '../typings/runtime';
export declare const fetchServerPage: ({ fetcher, path, query: rawQuery, workspace, deviceInfo, }: {
    path: string;
    query?: Record<string, string> | undefined;
    fetcher: GlobalFetch['fetch'];
    workspace?: string | undefined;
    deviceInfo?: DeviceInfo | undefined;
}) => Promise<ParsedServerPageResponse>;
interface PrefetchPageResponse {
    page: string;
    queryData: RenderRuntime['queryData'];
    contentResponse: ContentResponse | null;
    route: RenderRuntime['route'];
}
export declare const isPrefetchEnabled: (storeSettings: Record<string, any> | null | undefined) => boolean;
export declare const isPrefetchActive: (storeSettings: Record<string, any> | null | undefined) => boolean;
export declare const getPrefetchForPath: ({ fetcher, path, query: rawQuery, workspace, }: {
    path: string;
    query?: Record<string, string> | undefined;
    fetcher: GlobalFetch['fetch'];
    workspace?: string | undefined;
}) => Promise<PrefetchPageResponse | null>;
interface FetchRouteDataArgs {
    apolloClient: ApolloClientType;
    routeId: string;
    declarer: string | null;
    query?: string;
    hints: RenderRuntime['hints'];
    renderMajor: number;
}
export declare const fetchRouteData: ({ apolloClient, routeId, declarer, query, hints, renderMajor, }: FetchRouteDataArgs) => Promise<PrefetchRouteData>;
export declare const fetchNavigationPage: ({ apolloClient, routeId, declarer, production, paramsJSON, renderMajor, skipCache, query, }: FetchNavigationDataInput) => Promise<ParsedPageQueryResponse>;
export declare const fetchDefaultPages: ({ apolloClient, pages, routeIds, renderMajor, }: FetchDefaultPages) => Promise<ParsedDefaultPagesQueryResponse>;
export {};
