import { History } from 'history';
import { NavigationRoute, RelativeScrollToOptions, RenderScrollOptions } from '../typings/global';
import { Pages } from '../typings/runtime';
export declare function getComparablePrecedence(path: string): string;
export declare function pathFromPageName(page: string, pages: Pages, params: any): string | null;
export declare function queryStringToMap(query: string): Record<string, any>;
export declare function mapToQueryString(query?: Record<string, any>): string;
export declare function getPageParams(path: string, routePath: string): Readonly<{}>;
export declare function getRouteFromPath(path: string, pages: Pages): NavigationRoute | null;
export declare function getRouteFromPathOld(path: string, pages: Pages, query?: string, hash?: string): NavigationRoute | null;
export declare function getNavigationRouteToNavigate(pages: Pages, options: NavigateOptions, showLogs?: boolean): any;
export declare function navigate(history: History | null, pages: Pages, options: NavigateOptions): boolean;
export declare function goBack(history: History | null): boolean;
export declare function scrollTo(options: RelativeScrollToOptions): void;
export interface NavigateOptions {
    hash?: string;
    page?: string;
    params?: any;
    query?: any;
    to?: string;
    scrollOptions?: RenderScrollOptions;
    fallbackToWindowLocation?: boolean;
    replace?: boolean;
    fetchPage?: boolean;
    preventRemount?: boolean;
    rootPath?: string;
    modifiers?: Set<NavigationRouteModifier>;
    modifiersOptions?: Record<string, any>;
    skipSetPath?: boolean;
}
export interface NavigationRouteChange {
    path: string;
    query?: string;
    options?: Record<string, NavigationRouteChange>;
}
export declare type NavigationRouteModifier = (navigationRoute: NavigationRouteChange) => NavigationRouteChange;
