import { GraphQLError } from 'graphql';
export interface ExtendedGraphQLError extends GraphQLError {
    operationId: string;
    extensions: {
        code: string;
        exception: {
            stacktrace: string;
            name?: string;
        };
    };
}
export declare function isExtendedGraphQLError(error: GraphQLError): error is ExtendedGraphQLError;
declare class GraphQLErrorsStore {
    private operationIds;
    addOperationIds(errors: readonly GraphQLError[]): void;
    getOperationIds(): string[];
}
declare const Store: GraphQLErrorsStore;
export default Store;
