import PageCacheControl from '../cacheControl';
import { QueryData } from '../apolloCache';
import { RenderProvider } from '../../components/RenderProvider';
import { ApolloClientType } from '../../typings/global';
import { RenderRuntime } from '../../typings/runtime';
export interface ApolloClientFunctions {
    getClient: (instance: RenderProvider) => ApolloClientType;
    hydrate: (queryData: QueryData[] | undefined) => Promise<void>;
}
export declare const buildCacheLocator: (app: string, type: string, cacheId: string) => string;
export declare const getState: (runtime: RenderRuntime) => import("apollo-cache-inmemory").NormalizedCacheObject;
export declare const createApolloClient: (runtime: RenderRuntime, baseURI: string, sessionPromise: Promise<void>, cacheControl?: PageCacheControl | undefined) => Promise<ApolloClientFunctions>;
