import { AssetEntry, RenderComponent } from '../typings/global';
import { RenderRuntime, StyleRef, Extensions } from '../typings/runtime';
export declare const getVTEXImgHost: (account: string) => string;
export declare function addScriptToPage(src: string): Promise<void>;
export declare const hotReloadOverrides: () => void;
export declare const hotReloadTachyons: () => void;
export declare function shouldAddScriptToPage(path: string, scripts?: string[]): boolean;
export declare function getLoadedImplementation<P = {}, S = {}>(component: string): RenderComponent<P, S>;
export declare function getImplementation<P = {}, S = {}>(component: string | undefined): RenderComponent<P, S> | null;
export declare function hasComponentImplementation(component: string): boolean;
export declare function getExtensionImplementation<P = {}, S = {}>(extensions: Extensions, name: string): RenderComponent<P, S> | null;
export declare function fetchUncriticalStyles(refs: StyleRef[]): Promise<Array<UncriticalStyle>>;
export declare function fetchAssets(runtime: RenderRuntime, assets: AssetEntry[]): Promise<void>;
export declare function prefetchAssets(runtime: RenderRuntime, assets: AssetEntry[]): void;
export declare type UncriticalStyle = {
    href: string;
    media: string;
    className?: string;
    id?: string;
    body: string;
} | null;
