import { MutableRefObject } from 'react';
interface IntersectionEvent {
    entry: IntersectionObserverEntry;
    unobserve: () => void;
}
interface HookOptions {
    ref: MutableRefObject<HTMLElement | null>;
    onView?: (event: IntersectionEvent) => any;
    threshold?: number;
    once?: boolean;
    bailOut?: boolean;
    initializeOnInteraction?: boolean;
}
/** Hook for detecting when an element is inside the viewport.
 * Differs from react-intersection-observer (https://www.npmjs.com/package/react-intersection-observer)
 * in that this hook doesn't use setState, using a callback approach instead, to improve
 * performance by preventing re-rendering.
 */
declare const useOnView: ({ ref, onView, threshold, once, bailOut, initializeOnInteraction, }: HookOptions) => void;
export { useOnView };
