import 'apollo-cache-inmemory';
import 'apollo-client';
import 'apollo-link-http';
import 'apollo-link-persisted-queries';
import 'apollo-upload-client';
import 'apollo-utilities';
import 'classnames';
import 'graphql';
import React from 'react';
import Helmet from '../components/Helmet';
import NoSSR, { useSSR } from '../components/NoSSR';
import Loading from '../components/Loading';
import { LazyImages, useLazyImagesContext } from '../components/LazyImages';
import { LoadingContextProvider } from '../components/LoadingContext';
import { ChildBlock } from '../components/ChildBlock';
import { useChildBlock } from '../components/useChildBlock';
import ExtensionContainer from '../components/ExtensionPoint/ExtensionContainer';
import ExtensionPoint from '../components/ExtensionPoint';
import Block from '../components/Block';
import LayoutContainer from '../components/LayoutContainer';
import LegacyExtensionContainer from '../components/ExtensionPoint/LegacyExtensionContainer';
import Link from '../components/Link';
import { RenderContext, withRuntimeContext } from '../components/RenderContext';
/** Important: Builder-Hub will only export types of functions imported from individual files.
 * So `useRuntime` should be imported from `../components/useRuntime` rather than
 * being imported along with the other functions from `RenderContext` */
import useRuntime from '../components/useRuntime';
import canUseDOM from '../components/canUseDOM';
import { buildCacheLocator } from '../utils/client';
import registerComponent from '../utils/registerComponent';
import { withSession } from '../utils/session';
import { useTreePath } from '../utils/treePath';
import withHMR from '../utils/withHMR';
import { Rendered } from '../typings/global';
import { RenderRuntime } from '../typings/runtime';
import '../typings/runtime';
declare const renderExtension: (extensionName: string, destination: HTMLElement, props?: {}) => void;
declare const render: (name: string, runtime: RenderRuntime, element?: HTMLElement | undefined) => Rendered;
declare function start(): void;
declare const RenderContextConsumer: React.Consumer<RenderContext>;
declare const TreePathContextConsumer: React.Consumer<import("../utils/treePath").TreePathProps>;
export { ExtensionContainer, 
/** Block is the preferred nomenclature now, ExtensionPoint is kept for
 * backwards compatibility
 */
Block, ExtensionPoint, LayoutContainer, LegacyExtensionContainer, Helmet, Link, NoSSR, useSSR, RenderContextConsumer, TreePathContextConsumer, LazyImages as ExperimentalLazyImages, useLazyImagesContext as useExperimentalLazyImagesContext, canUseDOM, render, start, withHMR, registerComponent, withRuntimeContext, ChildBlock, useChildBlock, useRuntime, useTreePath, withSession, Loading, LoadingContextProvider, buildCacheLocator, renderExtension, ChildBlock as Unstable__ChildBlock, useChildBlock as useChildBlock__unstable, };
