import { History } from 'history';
import PropTypes from 'prop-types';
import React, { Component, ReactElement } from 'react';
import { NavigateOptions, NavigationRouteModifier } from '../utils/pages';
import type { RenderContext } from './RenderContext';
import { WithDeviceProps } from '../utils/withDevice';
import { ApolloClientFunctions } from '../utils/client';
import { ConfigurationDevice, RenderHistoryLocation, SetQueryOptions, PageContextOptions } from '../typings/global';
import { RenderRuntime, Components, Extension } from '../typings/runtime';
interface Props {
    children: ReactElement<any> | null;
    history: History | null;
    root: string;
    runtime: RenderRuntime;
    sessionPromise: Promise<void>;
    apollo: ApolloClientFunctions;
}
export interface RenderProviderState {
    appsEtag: RenderRuntime['appsEtag'];
    cacheHints: RenderRuntime['cacheHints'];
    components: RenderRuntime['components'];
    culture: RenderRuntime['culture'];
    defaultExtensions: RenderRuntime['defaultExtensions'];
    device: ConfigurationDevice;
    deviceInfo: RenderRuntime['deviceInfo'];
    extensions: RenderRuntime['extensions'];
    inspect: RenderRuntime['inspect'];
    messages: RenderRuntime['messages'];
    page: RenderRuntime['page'];
    pages: RenderRuntime['pages'];
    preview: RenderRuntime['preview'];
    production: RenderRuntime['production'];
    query: RenderRuntime['query'];
    settings: RenderRuntime['settings'];
    route: RenderRuntime['route'];
    loadedDevices: RenderRuntime['loadedDevices'];
    loadedPages: Set<string>;
    blocksTree?: RenderRuntime['blocksTree'];
    blocks?: RenderRuntime['blocks'];
    contentMap?: RenderRuntime['contentMap'];
}
interface NavigationState {
    isNavigating: boolean;
    lastOptions?: NavigateOptions;
}
export declare class RenderProvider extends Component<Props & WithDeviceProps, RenderProviderState> {
    navigationState: NavigationState;
    static childContextTypes: {
        account: PropTypes.Requireable<string>;
        addMessages: PropTypes.Requireable<(...args: any[]) => any>;
        amp: PropTypes.Requireable<boolean>;
        binding: PropTypes.Requireable<object>;
        blocks: PropTypes.Requireable<object>;
        blocksTree: PropTypes.Requireable<object>;
        contentMap: PropTypes.Requireable<object>;
        components: PropTypes.Requireable<object>;
        culture: PropTypes.Requireable<object>;
        defaultExtensions: PropTypes.Requireable<object>;
        device: PropTypes.Requireable<string>;
        deviceInfo: PropTypes.Requireable<PropTypes.InferProps<{
            type: PropTypes.Requireable<string>;
            isMobile: PropTypes.Requireable<boolean>;
        }>>;
        isMobile: PropTypes.Requireable<boolean>;
        emitter: PropTypes.Requireable<object>;
        ensureSession: PropTypes.Requireable<(...args: any[]) => any>;
        extensions: PropTypes.Requireable<object>;
        fetchComponent: PropTypes.Requireable<(...args: any[]) => any>;
        fetchComponents: PropTypes.Requireable<(...args: any[]) => any>;
        getSettings: PropTypes.Requireable<(...args: any[]) => any>;
        goBack: PropTypes.Requireable<(...args: any[]) => any>;
        hints: PropTypes.Requireable<object>;
        history: PropTypes.Requireable<object>;
        inspect: PropTypes.Requireable<boolean>;
        messages: PropTypes.Requireable<object>;
        navigate: PropTypes.Requireable<(...args: any[]) => any>;
        onPageChanged: PropTypes.Requireable<(...args: any[]) => any>;
        page: PropTypes.Requireable<string>;
        pages: PropTypes.Requireable<object>;
        patchSession: PropTypes.Requireable<(...args: any[]) => any>;
        platform: PropTypes.Requireable<string>;
        prefetchDefaultPages: PropTypes.Requireable<(...args: any[]) => any>;
        addNavigationRouteModifier: PropTypes.Requireable<(...args: any[]) => any>;
        prefetchPage: PropTypes.Requireable<(...args: any[]) => any>;
        preview: PropTypes.Requireable<boolean>;
        production: PropTypes.Requireable<boolean>;
        publicEndpoint: PropTypes.Requireable<string>;
        query: PropTypes.Requireable<object>;
        renderMajor: PropTypes.Requireable<number>;
        rootPath: PropTypes.Requireable<string>;
        route: PropTypes.Requireable<object>;
        setDevice: PropTypes.Requireable<(...args: any[]) => any>;
        setQuery: PropTypes.Requireable<(...args: any[]) => any>;
        updateComponentAssets: PropTypes.Requireable<(...args: any[]) => any>;
        updateExtension: PropTypes.Requireable<(...args: any[]) => any>;
        updateRuntime: PropTypes.Requireable<(...args: any[]) => any>;
        workspace: PropTypes.Requireable<string>;
        navigationRouteModifiers: PropTypes.Requireable<object>;
    };
    static propTypes: {
        children: PropTypes.Requireable<PropTypes.ReactElementLike>;
        history: PropTypes.Requireable<object>;
        root: PropTypes.Requireable<string>;
        runtime: PropTypes.Requireable<object>;
    };
    sendInfoFromIframe: ((params?: {
        shouldUpdateRuntime?: boolean | undefined;
    } | undefined) => Promise<void> | undefined) & {
        clear(): void;
    } & {
        flush(): void;
    };
    private rendered;
    private sessionPromise;
    private unlisten;
    private apolloClient;
    private hydrateApollo;
    private prefetchRoutes;
    navigationRouteModifiers: Set<NavigationRouteModifier>;
    private navigationModifierOptions;
    private fetcher;
    constructor(props: Props & WithDeviceProps);
    componentDidMount(): void;
    UNSAFE_componentWillReceiveProps(nextProps: Props): void;
    componentWillUnmount(): void;
    getChildContext(): RenderContext;
    getSettings: (app: string) => any;
    ensureSession: () => Promise<void>;
    patchSession: (data?: any) => Promise<void | undefined>;
    getCustomMessages: (locale: string) => any;
    goBack: () => boolean;
    setQuery: (query?: Record<string, any>, { merge, replace, scrollOptions, }?: SetQueryOptions) => boolean;
    navigate: (options: NavigateOptions) => boolean;
    private updateDeviceBlocks;
    addNavigationRouteModifier: (modifier: NavigationRouteModifier) => void;
    replaceRouteClass: (route: string) => void;
    scrollTo: (scrollOptions?: false | import("../typings/global").RelativeScrollToOptions | undefined) => void;
    afterPageChanged: (route: string, scrollOptions?: false | import("../typings/global").RelativeScrollToOptions | undefined) => void;
    onPageChanged: (location: RenderHistoryLocation) => void | Promise<unknown>;
    prefetchPage: (pageName: string) => void;
    prefetchDefaultPages: (routeIds: string[]) => Promise<void>;
    updateComponentAssets: (availableComponents: Components) => void;
    fetchComponents: (components: RenderRuntime['components'], extensions?: import("../typings/runtime").Extensions | undefined) => Promise<void>;
    fetchComponent: RenderContext['fetchComponent'];
    onLocaleSelected: (locale: string, domain?: string | undefined) => void;
    updateRuntime: (options?: PageContextOptions | undefined) => Promise<void>;
    updateExtension: (name: string, extension: Extension) => Promise<void>;
    handleSetDevice: (device: ConfigurationDevice) => void;
    addMessages: (newMessages: RenderRuntime['messages']) => Promise<void>;
    private updateDevice;
    componentDidUpdate(): void;
    render(): JSX.Element;
    private updateMessages;
    private prefetchPages;
    private execPrefetchPages;
}
declare const _default: React.FC<Props>;
export default _default;
