import React, { ComponentType } from 'react';
import { History } from 'history';
import { ConfigurationDevice, RenderHistoryLocation, SetQueryOptions, PageContextOptions } from '../typings/global';
import { RenderRuntime, Components, Extension } from '../typings/runtime';
import { NavigationRouteModifier, NavigateOptions } from '../utils/pages';
export interface RenderContext extends Pick<RenderRuntime, 'account' | 'amp' | 'binding' | 'components' | 'contentMap' | 'culture' | 'defaultExtensions' | 'deviceInfo' | 'emitter' | 'extensions' | 'hints' | 'inspect' | 'messages' | 'page' | 'pages' | 'platform' | 'preview' | 'production' | 'publicEndpoint' | 'query' | 'renderMajor' | 'rootPath' | 'route' | 'workspace'> {
    addMessages: (newMessages: RenderRuntime['messages']) => Promise<void>;
    addNavigationRouteModifier: (modifier: NavigationRouteModifier) => void;
    ensureSession: () => Promise<void>;
    fetchComponent: (component: string) => Promise<unknown>;
    fetchComponents: (components: RenderRuntime['components'], extensions?: RenderRuntime['extensions']) => Promise<void>;
    getSettings: (app: string) => any;
    goBack: () => void;
    device: string;
    history: History | null;
    navigate: (options: NavigateOptions) => boolean;
    onPageChanged: (location: RenderHistoryLocation) => void;
    patchSession: (data?: any) => Promise<void>;
    prefetchDefaultPages: (routeIds: string[]) => Promise<void>;
    prefetchPage: (name: string) => void;
    setDevice: (device: ConfigurationDevice) => void;
    setQuery: (query?: Record<string, any>, options?: SetQueryOptions) => boolean;
    updateComponentAssets: (availableComponents: Components) => void;
    updateExtension: (name: string, extension: Extension) => Promise<void>;
    updateRuntime: (options?: PageContextOptions) => Promise<void>;
    navigationRouteModifiers: Set<NavigationRouteModifier>;
}
export interface RenderContextProps {
    runtime: RenderContext;
}
export interface EmitterProps {
    __emitter: RenderContext['emitter'];
}
export declare const RenderContext: React.Context<RenderContext>;
export declare const RenderContextProvider: React.FC<RenderContextProps>;
export declare const useRuntime: () => RenderContext;
export declare const withRuntimeContext: <TOriginalProps extends {} = {}>(Component: React.ComponentType<TOriginalProps & RenderContextProps>) => React.ComponentType<TOriginalProps>;
export declare const withEmitter: <TOriginalProps extends {} = {}>(Component: React.ComponentType<TOriginalProps & EmitterProps>) => React.ComponentType<TOriginalProps>;
