import { FC } from 'react';
import LRUCache from './LRUCache';
import PQueue from './PQueue';
import { History } from 'history';
import { RenderRuntime } from '../../typings/runtime';
import { PrefetchRouteData, ContentResponse } from '../../typings/global';
interface PathState {
    fetching: boolean;
    page?: string | null;
}
interface RoutePromise {
    promisePending: boolean;
    promise: Promise<PrefetchRouteData> | null;
}
interface PrefetchCacheObject {
    routeId: string;
    matchingPage: RenderRuntime['route'];
    contentResponse: ContentResponse | null;
    queryData?: RenderRuntime['queryData'];
}
export interface PrefetchState {
    routesCache: LRUCache<PrefetchRouteData>;
    pathsCache: {
        other: LRUCache<PrefetchCacheObject>;
        product: LRUCache<PrefetchCacheObject>;
        search: LRUCache<PrefetchCacheObject>;
    };
    pathsState: Record<string, PathState>;
    routePromise: Record<string, RoutePromise | null>;
    queue: PQueue;
}
export declare const getCacheForPage: (page: string) => LRUCache<PrefetchCacheObject>;
export declare const usePrefetch: () => PrefetchState;
export declare const PrefetchContextProvider: FC<{
    history: History<any> | null;
}>;
export declare const getPrefetechedData: (path: string) => {
    routeData: null;
    prefetchedPathData: null;
    destinationRouteId: null;
} | {
    routeData: PrefetchRouteData | null | undefined;
    prefetchedPathData: PrefetchCacheObject | undefined;
    destinationRouteId: string;
};
export declare const clearQueue: () => void;
export {};
