declare type PromiseFn = () => Promise<any>;
interface QueueObject {
    promise: PromiseFn;
    priority: number;
}
interface AddOptions {
    priority?: number;
}
interface Options {
    concurrency?: number;
    autoStart?: boolean;
}
declare class PQueue {
    queue: QueueObject[];
    concurrency: number;
    runningPromisesCount: number;
    isActive: boolean;
    constructor(options?: Options);
    pause(): void;
    clear(): void;
    add(promise: PromiseFn, options?: AddOptions): void;
    start(): void;
    private isFull;
    private canStart;
    private startPromise;
    private dequeue;
    private enqueue;
}
export default PQueue;
