import React, { FC } from 'react';
interface LazyImagesContext {
    lazyLoad: boolean;
    /** "native" uses the attribute "loading=lazy", which is good but only works
     * on Chrome. lazysizes is a JS plugin already provided by render-runtime,
     * with broader support, but the behaviour might be a little worse at times */
    method: 'native' | 'lazysizes';
}
declare const LazyImagesContext: React.Context<LazyImagesContext>;
interface LazyImagesProps {
    lazyLoad?: boolean;
    experimentalMethod?: LazyImagesContext['method'];
}
declare const LazyImages: FC<LazyImagesProps>;
declare const useLazyImagesContext: () => LazyImagesContext;
interface MaybeLazyImageProps {
    createElement: typeof React.createElement;
    imageProps: Record<string, any>;
}
declare const MaybeLazyImage: FC<MaybeLazyImageProps>;
export { LazyImages, MaybeLazyImage, useLazyImagesContext };
