"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prettyDOM = prettyDOM;
exports.logDOM = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _prettyFormat = _interopRequireDefault(require("pretty-format"));

var _helpers = require("./helpers");

function inCypress(dom) {
  const window = dom.ownerDocument && dom.ownerDocument.defaultView || undefined;
  return typeof global !== 'undefined' && global.Cypress || typeof window !== 'undefined' && window.Cypress;
}

const inNode = () => typeof process !== 'undefined' && process.versions !== undefined && process.versions.node !== undefined;

const getMaxLength = dom => inCypress(dom) ? 0 : process.env.DEBUG_PRINT_LIMIT || 7000;

const {
  DOMElement,
  DOMCollection
} = _prettyFormat.default.plugins;

function prettyDOM(dom, maxLength, options) {
  if (!dom) {
    dom = (0, _helpers.getDocument)().body;
  }

  if (typeof maxLength !== 'number') {
    maxLength = getMaxLength(dom);
  }

  if (maxLength === 0) {
    return '';
  }

  if (dom.documentElement) {
    dom = dom.documentElement;
  }

  let domTypeName = typeof dom;

  if (domTypeName === 'object') {
    domTypeName = dom.constructor.name;
  } else {
    // To don't fall with `in` operator
    dom = {};
  }

  if (!('outerHTML' in dom)) {
    throw new TypeError(`Expected an element or document but got ${domTypeName}`);
  }

  const debugContent = (0, _prettyFormat.default)(dom, (0, _extends2.default)({
    plugins: [DOMElement, DOMCollection],
    printFunctionName: false,
    highlight: inNode()
  }, options));
  return maxLength !== undefined && dom.outerHTML.length > maxLength ? `${debugContent.slice(0, maxLength)}...` : debugContent;
}

const logDOM = (...args) => console.log(prettyDOM(...args));
/* eslint no-console:0 */


exports.logDOM = logDOM;