import { Unit } from './units-constants';
import { RawNumberLocaleData, NumberFormatDigitOptions, NumberFormatDigitInternalSlots, NumberILD, NumberLocalePatternData, NumberLocaleInternalData } from '@formatjs/intl-utils';
/**
 * Check if a formatting number with unit is supported
 * @public
 * @param unit unit to check
 */
export declare function isUnitSupported(unit: Unit): boolean;
export declare type UnifiedNumberFormatOptions = Intl.NumberFormatOptions & NumberFormatDigitOptions & {
    localeMatcher?: 'lookup' | 'best fit';
    style?: 'decimal' | 'percent' | 'currency' | 'unit';
    compactDisplay?: 'short' | 'long';
    currencyDisplay?: 'symbol' | 'code' | 'name' | 'narrowSymbol';
    currencySign?: 'standard' | 'accounting';
    notation?: 'standard' | 'scientific' | 'engineering' | 'compact';
    signDisplay?: 'auto' | 'always' | 'never' | 'exceptZero';
    unit?: Unit;
    unitDisplay?: 'long' | 'short' | 'narrow';
};
export declare type ResolvedUnifiedNumberFormatOptions = Intl.ResolvedNumberFormatOptions & Pick<UnifiedNumberFormatInternal, 'currencySign' | 'unit' | 'unitDisplay' | 'notation' | 'compactDisplay' | 'signDisplay'>;
export declare type UnifiedNumberFormatPartTypes = Intl.NumberFormatPartTypes | 'exponentSeparator' | 'exponentMinusSign' | 'exponentInteger' | 'compact' | 'unit' | 'literal';
export interface UnifiedNumberFormatPart {
    type: UnifiedNumberFormatPartTypes;
    value: string;
}
interface UnifiedNumberFormatInternal extends NumberFormatDigitInternalSlots {
    locale: string;
    dataLocale: string;
    style: NonNullable<UnifiedNumberFormatOptions['style']>;
    currency?: string;
    currencyDisplay: NonNullable<UnifiedNumberFormatOptions['currencyDisplay']>;
    unit?: string;
    unitDisplay: NonNullable<UnifiedNumberFormatOptions['unitDisplay']>;
    currencySign: NonNullable<UnifiedNumberFormatOptions['currencySign']>;
    notation: NonNullable<UnifiedNumberFormatOptions['notation']>;
    compactDisplay: NonNullable<UnifiedNumberFormatOptions['compactDisplay']>;
    signDisplay: NonNullable<UnifiedNumberFormatOptions['signDisplay']>;
    useGrouping: boolean;
    patterns: NumberLocalePatternData;
    pl: Intl.PluralRules;
    boundFormat?: Intl.NumberFormat['format'];
    ild: NumberILD;
    numberingSystem: string;
}
export interface UnifiedNumberFormat {
    resolvedOptions(): ResolvedUnifiedNumberFormatOptions;
    formatToParts(x: number): UnifiedNumberFormatPart[];
    format(x: number): string;
}
export interface UnifiedNumberFormatConstructor {
    new (locales?: string | string[], options?: UnifiedNumberFormatOptions): UnifiedNumberFormat;
    (locales?: string | string[], options?: UnifiedNumberFormatOptions): UnifiedNumberFormat;
    __addLocaleData(...data: RawNumberLocaleData[]): void;
    supportedLocalesOf(locales: string | string[], options?: Pick<UnifiedNumberFormatOptions, 'localeMatcher'>): string[];
    getDefaultLocale(): string;
    __defaultLocale: string;
    localeData: Record<string, NumberLocaleInternalData>;
    availableLocales: string[];
    polyfilled: boolean;
}
export declare const UnifiedNumberFormat: UnifiedNumberFormatConstructor;
export {};
