"use strict";
/*
 * Copyright 2015, Yahoo Inc.
 * Copyrights licensed under the New BSD License.
 * See the accompanying LICENSE file for terms.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = require("react");
var injectIntl_1 = require("./injectIntl");
var message_1 = require("../formatters/message");
var utils_1 = require("../utils");
var shallowEquals_ = require("shallow-equal/objects");
var shallowEquals = shallowEquals_.default || shallowEquals_;
var defaultFormatMessage = function (descriptor, values) {
    if (process.env.NODE_ENV !== 'production') {
        console.error('[React Intl] Could not find required `intl` object. <IntlProvider> needs to exist in the component ancestry. Using default message as fallback.');
    }
    return message_1.formatMessage(__assign(__assign({}, utils_1.DEFAULT_INTL_CONFIG), { locale: 'en' }), utils_1.createFormatters(), descriptor, values);
};
var FormattedMessage = /** @class */ (function (_super) {
    __extends(FormattedMessage, _super);
    function FormattedMessage() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FormattedMessage.prototype.shouldComponentUpdate = function (nextProps) {
        var _a = this.props, values = _a.values, otherProps = __rest(_a, ["values"]);
        var nextValues = nextProps.values, nextOtherProps = __rest(nextProps, ["values"]);
        return (!shallowEquals(nextValues, values) ||
            !shallowEquals(otherProps, nextOtherProps));
    };
    FormattedMessage.prototype.render = function () {
        var _this = this;
        return (React.createElement(injectIntl_1.Context.Consumer, null, function (intl) {
            if (!_this.props.defaultMessage) {
                utils_1.invariantIntlContext(intl);
            }
            var _a = intl || {}, _b = _a.formatMessage, formatMessage = _b === void 0 ? defaultFormatMessage : _b, _c = _a.textComponent, Text = _c === void 0 ? React.Fragment : _c;
            var _d = _this.props, id = _d.id, description = _d.description, defaultMessage = _d.defaultMessage, values = _d.values, children = _d.children, _e = _d.tagName, Component = _e === void 0 ? Text : _e;
            var descriptor = { id: id, description: description, defaultMessage: defaultMessage };
            var nodes = formatMessage(descriptor, values);
            if (!Array.isArray(nodes)) {
                nodes = [nodes];
            }
            if (typeof children === 'function') {
                return children.apply(void 0, nodes);
            }
            if (Component) {
                // Needs to use `createElement()` instead of JSX, otherwise React will
                // warn about a missing `key` prop with rich-text message formatting.
                return React.createElement.apply(React, __spreadArrays([Component, null], nodes));
            }
            return nodes;
        }));
    };
    FormattedMessage.displayName = 'FormattedMessage';
    FormattedMessage.defaultProps = {
        values: {},
    };
    return FormattedMessage;
}(React.Component));
exports.default = FormattedMessage;
