"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderHook = exports.hooks = exports.cleanup = exports.act = exports.render = exports.flushPromises = void 0;
const react_1 = __importDefault(require("react"));
const react_2 = require("@testing-library/react");
Object.defineProperty(exports, "act", { enumerable: true, get: function () { return react_2.act; } });
Object.defineProperty(exports, "cleanup", { enumerable: true, get: function () { return react_2.cleanup; } });
const hooks = __importStar(require("@testing-library/react-hooks"));
exports.hooks = hooks;
const react_testing_1 = require("@apollo/react-testing");
const react_intl_1 = require("react-intl");
const apollo_cache_inmemory_1 = require("apollo-cache-inmemory");
const paths = __importStar(require("./modules/paths"));
const json_1 = require("./utils/json");
const { renderHook } = hooks;
exports.renderHook = renderHook;
const pkg = json_1.readJSON(paths.resolveAppPath('package.json'));
const getLocale = (optionsLocale) => {
    var _a;
    const locales = [
        optionsLocale,
        (_a = pkg.vtexTestTools) === null || _a === void 0 ? void 0 : _a.defaultLocale,
        'en',
        'en-US',
    ].filter(Boolean);
    const localeExists = (locale) => locale && paths.pathExists(`../messages/${locale}.json`);
    return locales.find(localeExists);
};
// Creating apollo-client cache like render-runtime
const generateCacheKey = (value) => {
    const { cacheId, __typename: typename } = value || {};
    if (value && cacheId && typename) {
        return `${typename}:${value.cacheId}`;
    }
    return null;
};
const customRender = (node, options = {}) => {
    const locale = getLocale(options.locale);
    const messages = locale
        ? json_1.readJSON(paths.resolveAppPath(`../messages/${locale}.json`))
        : {};
    const intlProps = {
        locale: locale !== null && locale !== void 0 ? locale : 'en',
        messages,
    };
    const apolloProps = options.graphql
        ? Object.assign({ addTypename: false }, options.graphql) : { addTypename: false, mocks: [] };
    const cache = new apollo_cache_inmemory_1.InMemoryCache({
        addTypename: apolloProps.addTypename,
        dataIdFromObject: generateCacheKey,
    });
    apolloProps.cache = cache;
    const rendered = react_2.render(react_1.default.createElement(react_intl_1.IntlProvider, Object.assign({}, intlProps),
        react_1.default.createElement(react_testing_1.MockedProvider, Object.assign({}, apolloProps), node)), options);
    return Object.assign(Object.assign({}, rendered), { rerender: (newUi) => customRender(newUi, {
            container: rendered.container,
            baseElement: rendered.baseElement,
        }) });
};
exports.render = customRender;
exports.flushPromises = () => new Promise((resolve) => setImmediate(resolve));
__exportStar(require("@testing-library/react"), exports);
//# sourceMappingURL=react.js.map