import React from 'react';
import { RenderOptions, act, cleanup } from '@testing-library/react';
import * as hooks from '@testing-library/react-hooks';
import { MockedProviderProps } from '@apollo/react-testing';
declare const renderHook: typeof hooks.renderHook;
declare type TestToolsRenderOptions = BaseTestToolsRenderOptions & Partial<GraphQLTestToolsRenderOptions>;
interface Messages {
    [id: string]: string;
}
interface BaseTestToolsRenderOptions extends RenderOptions {
    /** A locale string, eg: `pt-BR`, `es`. Default: `en` */
    locale?: string;
    /** A JSON translation to be used. Default: `messages/en.json` or another locale if specified in the `locale` option. */
    messages?: Messages;
}
interface GraphQLTestToolsRenderOptions {
    /** Props to be passed to MockedProvider */
    graphql: MockedProviderProps;
}
declare const customRender: (node: React.ReactElement, options?: TestToolsRenderOptions) => {
    rerender: (newUi: React.ReactElement) => any;
    container: HTMLElement;
    baseElement: HTMLElement;
    debug: (baseElement?: HTMLElement | DocumentFragment | (HTMLElement | DocumentFragment)[] | undefined, maxLength?: number | undefined, options?: import("pretty-format/build/types").OptionsReceived | undefined) => void;
    unmount: () => boolean;
    asFragment: () => DocumentFragment;
    getByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByLabelText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByPlaceholderText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").SelectorMatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByAltText: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByTitle: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByDisplayValue: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByRole: (text: import("@testing-library/react").ByRoleMatcher, options?: import("@testing-library/react").ByRoleOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
    getByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement;
    getAllByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    queryByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement | null;
    queryAllByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: unknown) => HTMLElement[];
    findByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement>;
    findAllByTestId: (text: import("@testing-library/react").Matcher, options?: import("@testing-library/react").MatcherOptions | undefined, waitForElementOptions?: import("@testing-library/react").waitForOptions | undefined) => Promise<HTMLElement[]>;
};
export declare const flushPromises: () => Promise<unknown>;
export * from '@testing-library/react';
export { customRender as render, act, cleanup, hooks, renderHook };
