"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.moduleName = exports.pathExists = exports.resolveAppPath = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const appDirectory = fs_1.default.realpathSync(process.cwd());
exports.resolveAppPath = (relative) => path_1.default.resolve(appDirectory, relative);
exports.pathExists = (relative) => {
    try {
        fs_1.default.accessSync(exports.resolveAppPath(relative), fs_1.default.constants.F_OK);
        return true;
    }
    catch (e) {
        return false;
    }
};
exports.moduleName = path_1.default.basename(process.cwd());
//# sourceMappingURL=paths.js.map