"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.goToProductPageByShelf = exports.scrollToId = exports.goToSearchPage = void 0;
const index_1 = require("./index");
function goToSearchPage(options) {
    if (!options) {
        return false;
    }
    if (options.categoryId) {
        cy.visit(options.categoryId);
        return true;
    }
    cy.visit('/');
    cy.get('[data-testid="categoryLink"]')
        .its('length')
        .then(($length) => {
        const itemIndex = options.random
            ? Math.floor(Math.random() * $length)
            : Number(options === null || options === void 0 ? void 0 : options.pageIndex);
        cy.get(`[data-testid="categoryLink"]`)
            .eq(itemIndex)
            .then(($link) => {
            const url = new URL($link.prop('href'));
            cy.intercept('GET', `/page-data/${url.pathname}/page-data.json`).as(`pageLoad${url.pathname}`);
            cy.get(`[data-testid="categoryLink"]`)
                .eq(itemIndex)
                .click({ force: true })
                .wait(`@pageLoad${url.pathname}`)
                .its('response.statusCode')
                .then(($code) => {
                if ($code < 200 || $code > 399) {
                    goToSearchPage({ categoryId: '', random: true, pageIndex: -1 });
                }
            });
        });
    });
    return true;
}
exports.goToSearchPage = goToSearchPage;
/*
  Pages: *
  Selectors: {{ param }}
*/
function scrollToId(dataTestId, { cyclesLimit = 5, cycles = 1 }) {
    if (cycles >= cyclesLimit)
        return false;
    cy.get('body').then(($body) => {
        if ($body.find(index_1.resolveIdentifier(dataTestId)).length) {
            return undefined;
        }
        cy.scrollTo(0, '100%');
        // For now, there is no way to wait for network calls (all of them) to be idle
        // eslint-disable-next-line cypress/no-unnecessary-waiting
        cy.wait(1000);
        return undefined;
    });
    return scrollToId(dataTestId, { cycles: cycles + 1 });
}
exports.scrollToId = scrollToId;
/*
  Pages: {{ param }}
  Selectors: shelfPage, productSummaryContainer
*/
function goToProductPageByShelf(pathUrl = '/', shelfIndex = 0, productIndex = 0) {
    cy.location().then(($location) => {
        if ($location.pathname !== pathUrl) {
            cy.visit(pathUrl);
        }
    });
    cy.get('[data-testid="shelfPage"]')
        .eq(shelfIndex)
        .within((_) => {
        cy.get(`[data-testid="productSummaryContainer"]`).eq(productIndex).click();
    });
}
exports.goToProductPageByShelf = goToProductPageByShelf;
//# sourceMappingURL=navigation.js.map