"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.goToProductPageByShelf = exports.goToSearchPage = exports.checkIfElementExists = exports.fillAndCheckShippingSimulator = exports.clearCart = exports.closeCart = exports.openCart = exports.checkText = exports.scrollToId = exports.identifierExists = exports.resolveIdentifier = void 0;
const fill_1 = require("./fill");
Object.defineProperty(exports, "fillAndCheckShippingSimulator", { enumerable: true, get: function () { return fill_1.fillAndCheckShippingSimulator; } });
const cart_1 = require("./cart");
Object.defineProperty(exports, "openCart", { enumerable: true, get: function () { return cart_1.openCart; } });
Object.defineProperty(exports, "closeCart", { enumerable: true, get: function () { return cart_1.closeCart; } });
Object.defineProperty(exports, "clearCart", { enumerable: true, get: function () { return cart_1.clearCart; } });
const find_1 = require("./find");
Object.defineProperty(exports, "checkIfElementExists", { enumerable: true, get: function () { return find_1.checkIfElementExists; } });
const assertion_1 = require("./assertion");
Object.defineProperty(exports, "checkText", { enumerable: true, get: function () { return assertion_1.checkText; } });
const navigation_1 = require("./navigation");
Object.defineProperty(exports, "scrollToId", { enumerable: true, get: function () { return navigation_1.scrollToId; } });
Object.defineProperty(exports, "goToSearchPage", { enumerable: true, get: function () { return navigation_1.goToSearchPage; } });
Object.defineProperty(exports, "goToProductPageByShelf", { enumerable: true, get: function () { return navigation_1.goToProductPageByShelf; } });
function resolveIdentifier(dataTestId) {
    let identifier = '';
    if (Array.isArray(dataTestId)) {
        dataTestId = dataTestId.map((id) => {
            return `[data-testid="${id}"]`;
        });
        identifier = dataTestId.join(' ');
    }
    else {
        identifier = `[data-testid="${dataTestId}"]`;
    }
    return identifier;
}
exports.resolveIdentifier = resolveIdentifier;
function identifierExists(dataTestId, options) {
    let exists = false;
    if (options === null || options === void 0 ? void 0 : options.index) {
        if (Cypress.$(resolveIdentifier(dataTestId)).eq(options === null || options === void 0 ? void 0 : options.index).length) {
            exists = true;
        }
        return exists;
    }
    if (Cypress.$(resolveIdentifier(dataTestId)).length) {
        exists = true;
    }
    return exists;
}
exports.identifierExists = identifierExists;
//# sourceMappingURL=index.js.map