"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearCart = exports.closeCart = exports.openCart = void 0;
/*
  Pages: *
  Selectors: openCart
*/
function openCart() {
    cy.get('[data-testid="openCart"').click();
}
exports.openCart = openCart;
/*
  Pages: *
  Selectors: closeCart
*/
function closeCart() {
    cy.get('[data-testid="closeCart"').should('be.visible').click();
}
exports.closeCart = closeCart;
/*
  Pages: *
  Selectors: minicartDelete
*/
function clearCart() {
    openCart();
    cy.get('body').then(($body) => {
        if ($body.find('[data-testid="minicartDelete"]').length) {
            cy.get('[data-testid="minicartDelete"]').each(($deleteIcon, _) => {
                cy.wrap($deleteIcon).click();
            });
        }
    });
    closeCart();
}
exports.clearCart = clearCart;
//# sourceMappingURL=cart.js.map