"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanup = cleanup;
exports.addCleanup = addCleanup;
exports.removeCleanup = removeCleanup;
let cleanupCallbacks = [];

async function cleanup() {
  for (const callback of cleanupCallbacks) {
    await callback();
  }

  cleanupCallbacks = [];
}

function addCleanup(callback) {
  cleanupCallbacks.unshift(callback);
  return () => removeCleanup(callback);
}

function removeCleanup(callback) {
  cleanupCallbacks = cleanupCallbacks.filter(cb => cb !== callback);
}