import React from 'react';

interface TerrificTimelineEmbedProps {
    timelineId: string;
    numberOfItems?: number;
    isRedirect?: boolean;
    customId?: string;
    customStyle?: string;
    height?: string;
    width?: string;
}

const TerrificTimelineEmbed: React.FC<TerrificTimelineEmbedProps> = ({ 
    timelineId, 
    numberOfItems = 8, 
    isRedirect = false, 
    customId, 
    customStyle,
    height = "50vh",
    width = "100%"
}) => {
    const iframeSrc = `https://polls.terrific.live/timeline/carrousel?id=${timelineId}&number-of-items=${numberOfItems}&is-redirect=${isRedirect}`;
    
    return (
        <div 
            id={customId || "terrific-timeline-div"} 
            style={{ 
                width: width, 
                height: height, 
                border: "none",
                ...(customStyle && JSON.parse(customStyle))
            }}
        >
            <iframe 
                id="terrific-timeline-iframe"
                src={iframeSrc}
                style={{ 
                    width: "100%", 
                    height: "100%", 
                    border: "none" 
                }}
                title="Timeline Display"
            />
        </div>
    );
};

export default TerrificTimelineEmbed;
