import React from 'react';

declare global {
  namespace JSX {
    interface IntrinsicElements {
      'terrific-live-session': React.DetailedHTMLProps<React.HTMLAttributes<HTMLElement>, HTMLElement> & { id?: string };
    }
  }
}

interface TerrificGenericEmbedProps {
    terrificEmbeddingId?: string;
    customId?: string;
    customStyle?: string;
}

const TerrificGenericEmbed: React.FC<TerrificGenericEmbedProps> = ({ terrificEmbeddingId, customId }) => {
    return (
        <>
            <div
                data-source="terrific"
                embedding-id={terrificEmbeddingId}
                id={customId || "terrific-embed"}
            ></div>
        </>
    );
};

export default TerrificGenericEmbed; 