# TerrificTimelineEmbed - Guía de Uso

## Descripción
El componente `TerrificTimelineEmbed` permite embeber timelines de Terrific en tu tienda VTEX.

## Uso Básico

### En un bloque JSON de VTEX:
```json
{
  "TerrificTimelineEmbed": {
    "props": {
      "timelineId": "sfb9wjOb0TpMrTzKXGA5",
      "numberOfItems": 8,
      "isRedirect": false,
      "height": "50vh"
    }
  }
}
```

### Con ID personalizado:
```json
{
  "TerrificTimelineEmbed": {
    "props": {
      "timelineId": "sfb9wjOb0TpMrTzKXGA5",
      "customId": "mi-timeline-personalizado",
      "height": "400px"
    }
  }
}
```

### Con estilos personalizados:
```json
{
  "TerrificTimelineEmbed": {
    "props": {
      "timelineId": "sfb9wjOb0TpMrTzKXGA5",
      "customStyle": "{\"borderRadius\": \"10px\", \"boxShadow\": \"0 4px 8px rgba(0,0,0,0.1)\"}",
      "height": "60vh"
    }
  }
}
```

## Propiedades Disponibles

| Propiedad | Tipo | Requerido | Descripción | Valor por defecto |
|-----------|------|-----------|-------------|-------------------|
| `timelineId` | string | ✅ | ID del timeline de Terrific | - |
| `numberOfItems` | number | ❌ | Número de elementos a mostrar | 8 |
| `isRedirect` | boolean | ❌ | Si debe redirigir | false |
| `customId` | string | ❌ | ID personalizado del contenedor | "terrific-timeline-div" |
| `customStyle` | string | ❌ | Estilos CSS personalizados en formato JSON | - |
| `height` | string | ❌ | Altura del contenedor | "50vh" |

## Ejemplo HTML Equivalente
El componente genera el siguiente HTML:
```html
<div id="terrific-timeline-div" style="width: 100%; height: 50vh; border: none;">
    <iframe 
        id="terrific-timeline-iframe"
        src="https://polls.terrific.live/timeline/carrousel?id=sfb9wjOb0TpMrTzKXGA5&number-of-items=8&is-redirect=false"
        style="width: 100%; height: 100%; border: none;"
        title="Timeline Display">
    </iframe>
</div>
```
