📢 Use this project, [contribute](https://github.com/{OrganizationName}/{AppName}) to it or open issues to help evolve it using [Store Discussion](https://github.com/vtex-apps/store-discussion).

# APP NAME

<!-- DOCS-IGNORE:start -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-0-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
<!-- DOCS-IGNORE:end -->

Under the app's name, you should explain the topic, giving a **brief description** of its **functionality** in a store when installed.

Next, **add media** (either an image of a GIF) with the rendered components, so that users can better understand how the app works in practice. 

![Media Placeholder](https://user-images.githubusercontent.com/52087100/71204177-42ca4f80-227e-11ea-89e6-e92e65370c69.png)

## Configuration 

In this section, you first must **add the primary instructions** that will allow users to use the app's blocks in their store, such as:

1. Adding the app as a theme dependency in the `manifest.json` file;
2. Declaring the app's main block in a given theme template or inside another block from the theme.

Remember to add a table with all blocks exported by the app and their descriptions. You can verify an example of it on the [Search Result documentation](https://vtex.io/docs/components/all/vtex.search-result@3.56.1/). 

Next, add the **props table** containing your block's props. 

If the app exports more than one block, create several tables - one for each block. For example:

### `block-1` props

| Prop name    | Type            | Description    | Default value                                                                                                                               |
| ------------ | --------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ---------- | 
| `XXXXX`      | `XXXXXX`       | XXXXXXXX         | `XXXXXX`        |


### `block-2` props

| Prop name    | Type            | Description    | Default value                                                                                                                               |
| ------------ | --------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ---------- | 
| `XXXXX`      | `XXXXXX`       | XXXXXXXX         | `XXXXXX`        |

Prop types are: 

- `string` 
- `enum` 
- `number` 
- `boolean` 
- `object` 
- `array` 

When documenting a prop whose type is `object` or `array` another prop table will be needed. You can create it following the example below:

- `propName` object:

| Prop name    | Type            | Description    | Default value                                                                                                                               |
| ------------ | --------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ---------- | 
| `XXXXX`      | `XXXXXX`       | XXXXXXXX         | `XXXXXX`        |


Remember to also use this Configuration section to  **showcase any necessary disclaimer** related to the app and its blocks, such as the different behavior it may display during its configuration. 

## Modus Operandi *(not mandatory)*

There are scenarios in which an app can behave differently in a store, according to how it was added to the catalog, for example. It's crucial to go through these **behavioral changes** in this section, allowing users to fully understand the **practical application** of the app in their store.

If you feel compelled to give further details about the app, such as it's **relationship with the VTEX admin**, don't hesitate to use this section. 

## Customization

The first thing that should be present in this section is the sentence below, showing users the recipe pertaining to CSS customization in apps:

`In order to apply CSS customizations in this and other blocks, follow the instructions given in the recipe on [Using CSS Handles for store customization](https://vtex.io/docs/recipes/style/using-css-handles-for-store-customization).`

Thereafter, you should add a single column table with the available CSS handles for the app, like the one below. Note that the Handles must be ordered alphabetically.

| CSS Handles |
| ----------- | 
| `XXXXX` | 
| `XXXXX` | 
| `XXXXX` | 
| `XXXXX` | 
| `XXXXX` |


If there are none, add the following sentence instead:

`No CSS Handles are available yet for the app customization.`

<!-- DOCS-IGNORE:start -->

## Contributors ✨

Thanks goes to these wonderful people:

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind are welcome!

<!-- DOCS-IGNORE:end -->

---- 

Check out some documentation models that are already live: 
- [Breadcrumb](https://github.com/vtex-apps/breadcrumb)
- [Image](https://vtex.io/docs/components/general/vtex.store-components/image)
- [Condition Layout](https://vtex.io/docs/components/all/vtex.condition-layout@1.1.6/)
- [Add To Cart Button](https://vtex.io/docs/components/content-blocks/vtex.add-to-cart-button@0.9.0/)
- [Store Form](https://vtex.io/docs/components/all/vtex.store-form@0.3.4/)

# Terrific Generic Embed

Esta aplicación permite agregar cualquier componente de Terrific como un bloque HTML personalizado en tu tienda VTEX.

## Instalación

1. Instala la aplicación en tu cuenta VTEX:
```bash
vtex link
```

## Uso en Store Theme

### 1. Declarar el bloque en el store-theme

En tu store-theme, necesitas declarar el bloque en el archivo `store-theme/store/blocks.json`:

```json
{
  "store.custom#terrific-embed": {
    "blocks": ["terrific-generic-embed"]
  }
}
```

### 2. Usar el bloque en una página

Puedes usar el bloque en cualquier página de tu store-theme. Por ejemplo, para agregarlo al HOME:

En `store-theme/store/blocks/home/home.jsonc`:
```json
{
  "store.home": {
    "blocks": [
      "flex-layout.row#home",
      "store.custom#terrific-embed"
    ]
  },
  "store.custom#terrific-embed": {
    "blocks": ["terrific-generic-embed"]
  }
}
```

### 3. Configurar las propiedades del bloque

En el admin de VTEX, ve a:
1. **Store Setup** > **CMS** > **Store Theme**
2. Encuentra la página donde agregaste el bloque
3. Haz clic en el bloque "Terrific Generic Embed"
4. Configura las siguientes propiedades:
   - **Terrific Embedding ID**: El ID de tu componente de Terrific
   - **Custom ID** (opcional): ID personalizado para el contenedor
   - **Custom Style** (opcional): Estilos CSS personalizados en formato JSON

### 4. Ejemplo completo para HOME

```json
{
  "store.home": {
    "blocks": [
      "flex-layout.row#home",
      "store.custom#terrific-embed"
    ]
  },
  "store.custom#terrific-embed": {
    "blocks": ["terrific-generic-embed"]
  },
  "terrific-generic-embed": {
    "props": {
      "terrificEmbeddingId": "tu-embedding-id-aqui",
      "customId": "mi-contenedor-personalizado",
      "customStyle": "{\"backgroundColor\": \"#ffffff\", \"borderRadius\": \"12px\", \"boxShadow\": \"0 4px 6px rgba(0,0,0,0.1)\"}"
    }
  }
}
```

## Propiedades del Bloque

### Propiedades Requeridas
- **terrificEmbeddingId** (string): El ID del componente de Terrific que se mostrará

### Propiedades Opcionales
- **customId** (string): ID personalizado para el contenedor HTML. Si no se especifica, se usa "terrific-embed"
- **customStyle** (string): Estilos CSS personalizados en formato JSON. Se combinan con los estilos por defecto

### Ejemplos de Custom Style

```json
// Estilo básico
"{\"backgroundColor\": \"#f0f0f0\", \"padding\": \"30px\"}"

// Estilo con sombra y bordes redondeados
"{\"backgroundColor\": \"#ffffff\", \"borderRadius\": \"12px\", \"boxShadow\": \"0 4px 6px rgba(0,0,0,0.1)\", \"border\": \"2px solid #e0e0e0\"}"

// Estilo minimalista
"{\"backgroundColor\": \"transparent\", \"border\": \"none\", \"padding\": \"0\"}"
```

## Estructura de Archivos

```
terrific-popup/
├── store/
│   └── interfaces.json              # Define el bloque para el store-theme
├── react/
│   └── TerrificGenericEmbed.js     # Componente React del bloque
├── manifest.json                   # Configuración de la app
└── docs/
    └── README.md                   # Esta documentación
```

## Características

- **Renderizado del lado del cliente**: El bloque se renderiza en el navegador
- **Estilos personalizables**: Puedes configurar estilos CSS desde el admin
- **ID personalizable**: Puedes asignar un ID único al contenedor
- **Estilos por defecto**: Incluye estilos básicos para mejor presentación
- **Mensaje de ayuda**: Si no se configura el Embedding ID, se muestra un mensaje informativo

## Notas Importantes

- El bloque se renderiza del lado del cliente (`"render": "client"`)
- Asegúrate de que el Terrific Embedding ID sea válido
- Los estilos personalizados deben estar en formato JSON válido
- Si no se configura el Terrific Embedding ID, se mostrará un mensaje de ayuda
- Los estilos personalizados se combinan con los estilos por defecto (los personalizados tienen prioridad)

## Casos de Uso

- **Live Sessions**: Para mostrar sesiones en vivo de Terrific
- **Recordings**: Para mostrar grabaciones de sesiones
- **Heatmaps**: Para mostrar mapas de calor
- **Cualquier componente de Terrific**: El bloque es genérico y puede mostrar cualquier contenido de Terrific
